document.addEventListener('DOMContentLoaded', () => {
  window.electron.onUpdateProgress((data) => {
    const progressBar = document.getElementById("progress-bar");
    const statusElement = document.getElementById("status");
    const text1 = document.querySelector(".text1");
    const files = document.getElementById("files");
    const totalFiles = document.getElementById("total-files");
    const speedElement = document.getElementById("speed");

    // Atualiza a barra de progresso
    if (progressBar && !isNaN(data.percentComplete)) {
      const percent = Math.min(100, Math.max(0, Math.round(data.percentComplete)));
      progressBar.style.width = `${percent}%`;
    }

    // Atualiza status
    if (data.textType === 'Downloading') {
      text1.textContent = `Downloading: ${data.fileName}`;
      //text1.style.display = "block";
      statusElement.textContent = `Baixando arquivos...`;
      files.textContent = `Baixando: ${data.fileName}`;
    } else if (data.textType === 'Extracting') {
      text1.textContent = `Extracting: ${data.fileName}`;
      statusElement.textContent = `Descompactando arquivos...`;
      totalFiles.textContent = `Arquivos restantes: ${data.totalFiles || 0}`;
    }

    // Atualiza versões
    if (data.currentVersion !== undefined && data.latestVersion !== undefined) {
      document.querySelector(".currentversion").textContent = data.currentVersion;
      document.querySelector(".latestversion").textContent = data.latestVersion;
    }

    // Atualiza velocidade
    if (data.speed && speedElement) {
      let unit = 'MB/s';
      if (data.textType === 'Extracting') {
        unit = 'arquivos/s';
      }
      speedElement.textContent = `Velocidade: ${data.speed} ${unit}`;
      speedElement.style.display = "block";
    }
  });

  window.electron.onDownloadSpeed((data) => {
    const speedElement = document.getElementById("speed");
    if (!speedElement) return;

    let label = 'Velocidade';
    if (data.type === 'download') label = 'Download';
    else if (data.type === 'extract') label = 'Extração';

    speedElement.textContent = `${label}: ${data.speed} ${data.type === 'download' ? 'MB/s' : 'arquivos/s'}`;
    speedElement.style.display = 'block';
  });

});
